<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('sale_invoice_sub_details', function (Blueprint $table) {
            $table->unsignedBigInteger('task_status_id')->nullable()->after('data_referrence_id');
            $table->unsignedBigInteger('review_status_id')->nullable()->after('data_referrence_id');
            $table->unsignedBigInteger('task_created_by_id')->nullable()->after('data_referrence_id');
            $table->unsignedBigInteger('task_edited_by_id')->nullable()->after('data_referrence_id');
            $table->unsignedBigInteger('task_reviewed_by_id')->nullable()->after('data_referrence_id');
            $table->dateTime('task_created_at')->nullable()->after('data_referrence_id');
            $table->dateTime('task_edited_at')->nullable()->after('data_referrence_id');
            $table->dateTime('task_reviewed_at')->nullable()->after('data_referrence_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('sale_invoice_sub_details', function (Blueprint $table) {
            $table->dropColumn('task_status_id');
            $table->dropColumn('review_status_id');
            $table->dropColumn('task_created_by_id');
            $table->dropColumn('task_edited_by_id');
            $table->dropColumn('task_reviewed_by_id');
            $table->dropColumn('task_created_at');
            $table->dropColumn('task_edited_at');
            $table->dropColumn('task_reviewed_at');
        });
    }
};
