<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('employees', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('account_id')->nullable();
            $table->unsignedBigInteger('designation_id')->nullable();
            $table->unsignedBigInteger('department_id')->nullable();
            $table->unsignedBigInteger('gender_id')->nullable();
            $table->unsignedBigInteger('reporting_to')->nullable();
            $table->unsignedBigInteger('language_id')->nullable();
            $table->unsignedBigInteger('title_id')->nullable();
            $table->unsignedBigInteger('country_id')->nullable();
            $table->unsignedBigInteger('state_id')->nullable();
            $table->unsignedBigInteger('city_id')->nullable();
            $table->unsignedBigInteger('employee_type_id')->nullable();
            $table->unsignedBigInteger('marital_status_id')->nullable();
            $table->unsignedBigInteger('role_in_project_id')->nullable();
            $table->string('name');
            $table->string('email');
            $table->date('date_of_birth');
            $table->date('joining_date');
            $table->string('phone_no', 15)->nullable();
            $table->string('user_role')->nullable();
            $table->text('address')->nullable();
            $table->text('about')->nullable();
            $table->string('skills')->nullable();
            $table->date('probation_end_date')->nullable();
            $table->date('notice_period_start_date')->nullable();
            $table->date('notice_period_end_date')->nullable();
            $table->enum('login_allowed', ['yes', 'no'])->default('yes');
            $table->enum('recieve_email_notifications', ['yes', 'no'])->default('yes');
            $table->string('hourly_rate')->nullable();
            $table->string('slack_member_id')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('employees');
    }
};
