<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('voucher_collections', function (Blueprint $table) {
            $table->id();
            $table->date('collection_date')->nullable();
            $table->string('module_code')->nullable();
            $table->unsignedBigInteger('voucher_master_id')->nullable();
            $table->unsignedBigInteger('voucher_id')->nullable()->comment('voucher_id LIKE sale_invoice_id, Or receipt_id etc');
            $table->string('voucher_type')->nullable()->comment('SALE, PURCHASE, PAYMENT');
            $table->unsignedBigInteger('money_receipt_id')->nullable();
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->unsignedBigInteger('deleted_by')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('voucher_collections');
    }
};
