<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            if (!Schema::hasColumn('users', 'phone_no')) {
                $table->string('phone_no', 255)->nullable()->after('email');
            }

            if (!Schema::hasColumn('users', 'whatsapp_no')) {
                $table->string('whatsapp_no', 100)->nullable()->after('phone_no');
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            if (Schema::hasColumn('users', 'phone_no')) {
                $table->dropColumn('phone_no');
            }
            if (Schema::hasColumn('users', 'whatsapp_no')) {
                $table->dropColumn('whatsapp_no');
            }
        });
    }
};
