<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumn('notices', 'priority')) {
        Schema::table('notices', function (Blueprint $table) {
            $table->decimal('priority')->after('page_url')->nullable();
        });
    }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasColumn('notices', 'priority')) {
        Schema::table('notices', function (Blueprint $table) {
            $table->dropColumn('priority');
        });
    }
    }
};
