<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumn('public_content_category', 'company_id')) {
            Schema::table('public_content_category', function (Blueprint $table) {
            $table->unsignedBigInteger('company_id')->nullable()->after('status');
        });
    }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasColumn('public_content_category', 'company_id')) {
        Schema::table('public_content_category', function (Blueprint $table) {
            $table->dropColumn('company_id');
        });
    }
    }
};
