<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('countries', function (Blueprint $table) {
            $table->string('gsm_code')->change()->nullable();
            $table->string('currency_fullname')->change()->nullable();
            $table->string('currency_short_name')->change()->nullable();
            $table->string('currency_symbol')->change()->nullable();
            $table->string('formats')->change()->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('countries', function (Blueprint $table) {
            $table->string('gsm_code')->change();
            $table->string('currency_fullname')->change();
            $table->string('currency_short_name')->change();
            $table->string('currency_symbol')->change();
            $table->string('formats')->change();
        });
    }
};
