<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('biling_intervals', function (Blueprint $table) {
            $table->id();
            $table->string('biling_interval')->nullable();
            $table->integer('per_year')->nullable();
            $table->integer('days')->nullable();
            $table->boolean('lifetime')->default(0);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('biling_intervals');
    }
};
