<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('license_details', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('order_id')->nullable();
            $table->string('product_token_no')->nullable();
            $table->unsignedBigInteger('server_id')->nullable();
            $table->string('front_end_url')->nullable();
            $table->string('back_end_url')->nullable();
            $table->unsignedBigInteger('product_id')->nullable();
            $table->unsignedBigInteger('product_price_id')->nullable();
            $table->unsignedBigInteger('billing_interval_id')->nullable();
            $table->integer('quantity');
            $table->integer('taxable_rate');
            $table->text('discount_type');
            $table->integer('discount_value');
            $table->date('registration_date')->nullable();
            $table->date('1st_activation')->nullable();
            $table->date('billing_start_date')->nullable();
            $table->text('production');
            $table->boolean('maintenance_mode')->default(0);
            $table->boolean('status')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('license_details');
    }
};
