<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('license_registereds', function (Blueprint $table) {
            $table->id();
            $table->date('order_date')->nullable();
            $table->date('license_date')->nullable();
            $table->string('license_no')->nullable();
            $table->string('project_code')->nullable();
            $table->unsignedBigInteger('bill_to_account_id')->nullable();
            $table->unsignedBigInteger('ship_to_account_id')->nullable();
            $table->unsignedBigInteger('billing_company_id')->nullable();
            $table->text('license_note');
            $table->text('client_remarks');
            $table->boolean('license_status')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('license_registereds');
    }
};
