<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('license_registereds', function (Blueprint $table) {
            $table->text('license_note')->nullable()->change();
            $table->text('client_remarks')->nullable()->change();
            $table->unsignedBigInteger('project_id')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('license_registereds', function (Blueprint $table) {
            $table->text('license_note')->nullable(false)->change();
            $table->text('client_remarks')->nullable(false)->change();
            $table->dropColumn('project_id');
        });
    }
};
