<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('license_details', function (Blueprint $table) {
            $table->integer('quantity')->nullable()->change();
            $table->integer('taxable_rate')->nullable()->change();
            $table->text('discount_type')->nullable()->change();
            $table->integer('discount_value')->nullable()->change();
            $table->text('production')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('license_details', function (Blueprint $table) {
            $table->integer('quantity')->nullable(false)->change();
            $table->integer('taxable_rate')->nullable(false)->change();
            $table->text('discount_type')->nullable(false)->change();
            $table->integer('discount_value')->nullable(false)->change();
            $table->text('production')->nullable(false)->change();
        });
    }
};
