<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('branches', function (Blueprint $table) {
            $table->id();
            $table->string('title',200)->nullable();
            $table->unsignedBigInteger('branch_type_id')->nullable();
            $table->text('address')->nullable();
            $table->string('email',150)->nullable();
            $table->string('phone',50)->nullable();
            $table->text('google_map')->nullable();
            $table->text('cover_image')->nullable();
            $table->decimal('priority')->nullable();
            $table->enum('status',['0','1'])->default(1);
            $table->unsignedBigInteger('company_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('branches');
    }
};
