<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('brands_logos', function (Blueprint $table) {
            $table->id();
            $table->string('name',120)->nullable();
            $table->text('details')->nullable();
            $table->text('image')->nullable();
            $table->enum('type',['Our Brands','As Featured In','Our Recognition','Our Technology','Our Clients'])->default('Our Brands');
            $table->enum('status',['0','1'])->default(1);
            $table->decimal('priority')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('brands_logos');
    }
};
