<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('payment_vouchers', function (Blueprint $table) {
            $table->id();
            $table->string('receipt_no')->nullable();
            $table->string('overall_receipt_no')->nullable();
            $table->date('receipt_date')->nullable();
            $table->text('remarks')->nullable();
            $table->string('module_code')->nullable();
            $table->unsignedInteger('financial_year_id')->nullable();
            $table->unsignedInteger('voucher_id')->nullable();
            $table->unsignedInteger('company_id')->nullable();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->unsignedInteger('deleted_by')->nullable();
            $table->boolean('voucher_status')->default(0);
            $table->integer('last_voucher_count')->nullable();
            $table->integer('last_voucher_type_count')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payment_vouchers');
    }
};
