<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('payment_voucher_details', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('payment_mode_id')->nullable();
            $table->integer('voucher_master_id')->nullable();
            $table->unsignedBigInteger('voucher_id')->comment('payment_voucher_id');
            $table->string('voucher_type')->comment('SALE, PURCHASE, PAYMENT');
            $table->unsignedBigInteger('module_code')->nullable();
            $table->unsignedBigInteger('account_id')->comment('From Account Table')->nullable();
            $table->enum('transaction_type',['DEBIT','CREDIT'])->comment('DEBIT,CREDIT');
            $table->tinytext('details_narration')->nullable();
            $table->decimal('amount',13,4)->default('0.0000');
            $table->unsignedInteger('created_by')->default('0');
            $table->unsignedInteger('company_id');
            $table->unsignedInteger('financial_year_id');
            $table->boolean('transactions_status');
            $table->date('transaction_date')->nullable();
            $table->string('transaction_referrence')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payment_voucher_details');
    }
};
