<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('contra_vouchers', function (Blueprint $table) {
            $table->id();
            $table->string('voucher_no', 25)->nullable();
            $table->date('transaction_date')->nullable();
            $table->string('reference')->nullable();
            $table->text('description')->nullable();
            $table->unsignedInteger('company_id')->nullable();
            $table->unsignedInteger('financial_year_id')->nullable();
            $table->boolean('voucher_status')->default('0');
            $table->unsignedInteger('created_by')->default('0');
            $table->boolean('voucher_approval_status')->default(0)->comment('1 Approved, 0 Not Approved');
            $table->integer('last_voucher_count')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('contra_vouchers');
    }
};
