<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('contra_voucher_transactions', function (Blueprint $table) {
            $table->id();
            $table->string('transactions_no')->nullable();
            $table->date('transaction_date')->nullable();
            $table->unsignedBigInteger('module_id')->nullable();
            $table->unsignedBigInteger('voucher_id')->comment('constra_voucher_id')->nullable();
            $table->string('voucher_type',25)->comment('SALE, PURCHASE, PAYMENT')->nullable();
            $table->unsignedBigInteger('account_id')->comment('From Account Table')->nullable();
            $table->enum('transaction_type',['DEBIT','CREDIT'])->comment('DEBIT,CREDIT')->nullable();
            $table->tinytext('details_narration')->nullable();
            $table->decimal('amount',13,4)->default('0.0000');
            $table->unsignedBigInteger('created_by')->default('0');
            $table->unsignedBigInteger('company_id')->nullable();
            $table->unsignedBigInteger('financial_year_id')->nullable();
            $table->boolean('transactions_status')->default('0');
            $table->unsignedBigInteger('currency_id')->default('0');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('contra_voucher_transactions');
    }
};
