<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('voucher_terms', function (Blueprint $table) {
            $table->id();
            $table->unsignedInteger('voucher_id')->nullable();
            $table->enum('position',['header','body','footer'])->default('body');
            $table->text('terms_and_condition')->nullable();
            $table->boolean('status')->default('1');
            $table->boolean('is_default')->default('0');
            $table->decimal('priority')->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('voucher_terms');
    }
};
