<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('temp_account_imports', function (Blueprint $table) {
            $table->string('account_type')->nullable()->after('pin');
            $table->string('whatsapp')->nullable()->after('pin');
            $table->string('email')->nullable()->after('pin');
            $table->string('contact_person')->nullable()->after('pin');
            $table->string('print_name')->nullable()->after('pin');
            $table->string('gender')->nullable()->after('pin');
            $table->string('marital_status')->nullable()->after('pin');
            $table->string('blood_group')->nullable()->after('pin');
            $table->string('bank_account_name')->nullable()->after('pin');
            $table->string('account_no')->nullable()->after('pin');
            $table->string('ifsc_code')->nullable()->after('pin');
            $table->string('bank_name')->nullable()->after('pin');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('temp_account_imports', function (Blueprint $table) {
            $table->dropColumn('account_type');
            $table->dropColumn('whatsapp');
            $table->dropColumn('email');
            $table->dropColumn('contact_person');
            $table->dropColumn('print_name');
            $table->dropColumn('marital_status');
            $table->dropColumn('blood_group');
            $table->dropColumn('gender');
            $table->dropColumn('bank_account_name');
            $table->dropColumn('account_no');
            $table->dropColumn('ifsc_code');
            $table->dropColumn('bank_name');
        });
    }
};
