<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('document_management', function (Blueprint $table) {
            $table->id();
            $table->string('document_no', 30)->nullable();
            $table->datetime('date_time')->nullable();
            $table->unsignedBigInteger('voucher_id')->nullable();
            $table->string('voucher_type', 150)->nullable();
            $table->text('document_note')->nullable();
            $table->text('file_url')->nullable();
            $table->unsignedBigInteger('account_id')->nullable();
            $table->unsignedBigInteger('company_id')->nullable();
            $table->unsignedBigInteger('user_id')->nullable();
            $table->decimal('priority');
            $table->boolean('status')->default(1);
            $table->boolean('is_default')->default(0);
            $table->integer('last_voucher_count')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('document_management');
    }
};
