<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('biling_intervals', function (Blueprint $table) {
            $table->enum('billing_type', ['single_billing', 'recurring_billing'])->default('single_billing')->after('lifetime');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('biling_intervals', function (Blueprint $table) {
            $table->dropColumn('billing_type');
        });
    }
};
