<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('sale_invoices', function (Blueprint $table) {
            $table->dropColumn('remarks_for_technician');
            $table->dropColumn('sample_receive_date');
            $table->dropColumn('sample_receive_time');
            $table->dropColumn('sample_barcode');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('sale_invoices', function (Blueprint $table) {
            $table->text('remarks_for_technician')->nullable();
            $table->date('sample_receive_date')->nullable();
            $table->time('sample_receive_time')->nullable();
            $table->text('sample_barcode')->nullable();
        });
    }
};
