<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('sale_invoice_batches', function (Blueprint $table) {
            $table->text('remarks_for_technician')->nullable()->after('last_voucher_count');
            $table->date('sample_receive_date')->nullable()->after('last_voucher_count');
            $table->time('sample_receive_time')->nullable()->after('last_voucher_count');
            $table->text('sample_barcode')->nullable()->after('last_voucher_count');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('sale_invoice_batches', function (Blueprint $table) {
            $table->dropColumn('remarks_for_technician');
            $table->dropColumn('sample_receive_date');
            $table->dropColumn('sample_receive_time');
            $table->dropColumn('sample_barcode');
        });
    }
};
