<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sale_orders', function (Blueprint $table) {
            $table->id();
            $table->text('main_order_no')->nullable();
            $table->string('branch_order_no')->nullable();
            $table->unsignedBigInteger('voucher_type_code')->nullable();
            $table->unsignedBigInteger('patient_id')->nullable();
            $table->unsignedBigInteger('doctor_id')->nullable();
            $table->string('order_type')->nullable();
            $table->unsignedBigInteger('collection_agent_id')->nullable();
            $table->unsignedBigInteger('refferal_lab_id')->nullable();
            $table->text('reff_no')->nullable();
            $table->unsignedBigInteger('bussiness_source_id')->nullable();
            $table->unsignedBigInteger('payment_term_id')->nullable();
            $table->decimal('billing_amount', 10, 3)->nullable();
            $table->decimal('received_amount', 10, 3)->nullable();
            $table->decimal('discount_amount', 10, 3)->nullable();
            $table->decimal('due_amount', 10, 3)->nullable();
            $table->date('order_date')->nullable();
            $table->text('remarks')->nullable();
            $table->unsignedBigInteger('broker_id')->nullable();
            $table->unsignedBigInteger('operator_id')->nullable();
            $table->unsignedBigInteger('company_id')->nullable();
            $table->text('status')->nullable();
            $table->unsignedBigInteger('financial_year_id')->nullable();
            $table->unsignedInteger('industry_type_id')->nullable();
            $table->unsignedBigInteger('dispatch_from_id')->nullable();
            $table->unsignedBigInteger('ship_to_id')->nullable();
            $table->unsignedBigInteger('tracking_id')->nullable();
            $table->unsignedBigInteger('special_case_id')->nullable();
            $table->unsignedBigInteger('last_voucher_count')->nullable();
            $table->unsignedBigInteger('last_voucher_type_count')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sale_orders');
    }
};
