<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sale_order_batches', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('order_id')->nullable();
            $table->date('order_batch_date')->nullable();
            $table->integer('order_batch_no')->nullable();
            $table->unsignedBigInteger('account_id')->nullable();
            $table->integer('last_voucher_count')->nullable();
            $table->integer('created_by')->nullable();
            $table->integer('updated_by')->nullable();
            $table->text('remarks_for_technician')->nullable();
            $table->date('sample_receive_date')->nullable();
            $table->time('sample_receive_time')->nullable();
            $table->text('sample_barcode')->nullable();
            $table->string('order_batch_no')->nullable()->change();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sale_order_batches');
    }
};
