<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('voucher_masters', function (Blueprint $table) {
            $table->enum('tax_calculation', ['INCLUSIVE', 'EXCLUSIVE'])->default('EXCLUSIVE')->after('decimal_length');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('voucher_masters', function (Blueprint $table) {
            $table->dropColumn('tax_calculation');
        });
    }
};
