<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('ac_receipts', function (Blueprint $table) {
            $table->enum('advance_received',['Yes','No'])->default('No')->after('voucher_status');
            $table->enum('settlement_status',['Yes','No'])->default('Yes')->after('voucher_status');
            $table->string('settlement_module_code')->nullable()->after('voucher_status');
            $table->unsignedBigInteger('settlement_voucher_id')->nullable()->after('voucher_status');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ac_receipts', function (Blueprint $table) {
            $table->dropColumn('advance_received');
            $table->dropColumn('settlement_status');
            $table->dropColumn('settlement_module_code');
            $table->dropColumn('settlement_voucher_id');
        });
    }
};
