<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('menu_model_permissios', function (Blueprint $table) {
            $table->string('url')->nullable()->after('priority');
            $table->string('color')->nullable()->after('url');
            $table->enum('target', ['self', 'blank'])->nullable()->after('icon');
            $table->string('route')->nullable()->after('target');
            $table->string('route_named')->nullable()->after('route');
            $table->text('parameters')->nullable()->after('route_named');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('menu_model_permissios', function (Blueprint $table) {
             $table->dropColumn('url')->nullable();
            $table->dropColumn('color')->nullable();
            $table->dropColumn('target')->nullable();
            $table->dropColumn('route')->nullable();
            $table->dropColumn('route_named')->nullable();
            $table->dropColumn('parameters')->nullable();
        });
    }
};
