<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('plane_and_packages', function (Blueprint $table) {
            $table->id();
            $table->string('plan_name', 45)->nullable();
            $table->unsignedBigInteger('industry_type_id');
            $table->string('plan_code', 45)->nullable();
            $table->text('features_details')->nullable();
            $table->boolean('status')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('plane_and_packages');
    }
};
