<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('plan_module_mappings', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger("plan_id")->nullable();
            $table->string("module_code")->nullable();
            $table->string("parent_module_code")->nullable();
            $table->decimal("priority")->nullable();
            $table->boolean("status")->nullable()->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('plan_module_mappings');
    }
};
