<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('license_authentications', function (Blueprint $table) {
            $table->id();
            $table->string("license_key", 16)->nullable();
            $table->string("license_secret", 64)->nullable();
            $table->string("license_type", 32)->nullable();
            $table->string("api_endpoint", 255)->nullable();
            $table->string("api_endpoint_ip", 64)->nullable();
            $table->string("api_endpoint_port", 16)->nullable();
            $table->boolean("is_default")->nullable()->default(0);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('license_authentications');
    }
};
