<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('voucher_track_statuses', function (Blueprint $table) {
            $table->id();
            $table->string("module_code", 25)->nullable();
            $table->string("voucher_code", 50)->nullable();
            $table->string("voucher_type_code", 50)->nullable();
            $table->string("status_name", 50)->nullable();
            $table->string("status_code", 50)->nullable();
            $table->string("detail", 255)->nullable();
            $table->decimal("priority")->nullable();
            $table->boolean('status')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('voucher_track_statuses');
    }
};
