<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('companies_license', function (Blueprint $table) {
            $table->enum('page_position',['Header','Footer'])->after('is_default');
            $table->enum('view_priority',['Top','Bottom'])->after('is_default');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('companies_license', function (Blueprint $table) {
            $table->dropColumn('page_position');
            $table->dropColumn('view_priority');
        });
    }
};
