<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('company_images', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('company_id')->nullable();
            $table->string('image_url')->nullable();
            $table->string('image_type')->nullable();
            $table->string('height')->nullable();
            $table->string('width')->nullable();
            $table->string('top_margin')->nullable();
            $table->string('bottom_margin')->nullable();
            $table->string('left_margin')->nullable();
            $table->string('right_margin')->nullable();
            $table->string('top_padding')->nullable();
            $table->string('bottom_padding')->nullable();
            $table->string('left_padding')->nullable();
            $table->string('right_padding')->nullable();
            $table->string('alignment')->nullable();
            $table->boolean('status')->default(1);
            $table->decimal('priority')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('company_images');
    }
};
