<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('company_images', function (Blueprint $table) {
            $table->string('top_margin')->nullable()->default(1)->change();
            $table->string('bottom_margin')->nullable()->default(1)->change();
            $table->string('left_margin')->nullable()->default(1)->change();
            $table->string('right_margin')->nullable()->default(1)->change();
            $table->string('top_padding')->nullable()->default(1)->change();
            $table->string('bottom_padding')->nullable()->default(1)->change();
            $table->string('left_padding')->nullable()->default(1)->change();
            $table->string('right_padding')->nullable()->default(1)->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('company_images', function (Blueprint $table) {
            $table->string('top_margin')->change();
            $table->string('bottom_margin')->change();
            $table->string('left_margin')->change();
            $table->string('right_margin')->change();
            $table->string('top_padding')->change();
            $table->string('bottom_padding')->change();
            $table->string('left_padding')->change();
            $table->string('right_padding')->change();
        });
    }
};
