<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('tbl_stocks', function (Blueprint $table) {
            $table->unsignedBigInteger('voucher_id')->nullable()->after('invoice_id');
            $table->unsignedBigInteger('voucher_type')->nullable()->after('invoice_id');
            $table->integer('batch_id')->nullable()->after('invoice_id');
            $table->integer('rack_location_id')->nullable()->after('invoice_id');
            $table->decimal('pack_qty_in',10,3)->nullable()->after('invoice_id');
            $table->decimal('loose_qty_in',10,3)->nullable()->after('invoice_id');
            $table->decimal('pack_qty_out',10,3)->nullable()->after('invoice_id');
            $table->decimal('loose_qty_out',10,3)->nullable()->after('invoice_id');
            $table->integer('created_by_user_id')->nullable()->after('invoice_id');
            $table->integer('updated_by_user_id')->nullable()->after('invoice_id');

            // $table->foreign('created_by_user_id')->references('id')->on('users')->onDelete('cascade');
            // $table->foreign('updated_by_user_id')->references('id')->on('users')->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('tbl_stocks', function (Blueprint $table) {
            $table->dropColumn(['voucher_id',
                                'voucher_type',
                                'batch_id',
                                'rack_location_id',
                                'pack_qty_in',
                                'loose_qty_in',
                                'pack_qty_out',
                                'loose_qty_out',
                                'created_by_user_id',
                                'updated_by_user_id']);
        });
    }
};
