<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('voucher_types', function (Blueprint $table) {
            $table->enum('default_price_type',['MRP','Purchase Price','WholeSale Price','Discounted/Sale Price(DP)','Min. Sale Price'])->default('MRP')->nullable()->after('tax_applicable');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('voucher_types', function (Blueprint $table) {
            $table->dropColumn('default_price_type');
        });
    }
};
