<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('stocks', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('voucher_id')->nullable();
            $table->string('voucher_type',20)->nullable();
            $table->date('entry_date')->nullable();
            $table->string('stock_type')->nullable();
            $table->integer('product_id')->nullable();
            $table->integer('batch_id')->nullable();
            $table->integer('attribute_id')->nullable();
            $table->integer('rack_location_id')->nullable();
            $table->decimal('pack_qty_in',10,3)->nullable();
            $table->decimal('loose_qty_in',10,3)->nullable();
            $table->decimal('pack_qty_out',10,3)->nullable();
            $table->decimal('loose_qty_out',10,3)->nullable();
            $table->decimal('taxable_unit_price',10,3)->nullable();
            $table->integer('created_by_user_id')->nullable();
            $table->integer('updated_by_user_id')->nullable();
            $table->integer('company_id')->nullable();
            $table->integer('financial_year_id')->nullable();
            $table->integer('status')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('stocks');
    }
};
