<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('accounts', function (Blueprint $table) {
            $table->date('abha_verification_date')->after('unique_register_no')->nullable();
            $table->enum('abha_verified',['0','1'])->comment('1 is verify and 0 is not verify')->default(0)->after('unique_register_no')->nullable();
            $table->string('abha_address',30)->after('unique_register_no')->nullable();
            $table->string('abha_no',20)->after('unique_register_no')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('accounts', function (Blueprint $table) {
            $table->dropColumn(['abha_no','abha_address','abha_verified','abha_verification_date']);
        });
    }
};
