<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('product_prices', function (Blueprint $table) {
            $table->decimal('opening_stock_pack', 10, 2)->nullable()->change();
            $table->decimal('opening_stock_loose', 10, 2)->nullable()->change();
            $table->decimal('opening_stock_value', 10, 2)->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('product_prices', function (Blueprint $table) {
            $table->text('opening_stock_pack')->nullable()->change();
            $table->text('opening_stock_loose')->nullable()->change();
            $table->text('opening_stock_value')->nullable()->change();
        });
    }
};
