<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('sale_invoice_batches', function (Blueprint $table) {
            $table->unsignedBigInteger('referrence_voucher_id')->nullable()->after('last_voucher_count');
            $table->string('referrence_voucher_type', 60)->nullable()->after('last_voucher_count');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('sale_invoice_batches', function (Blueprint $table) {
            $table->dropColumn('referrence_voucher_id');
            $table->dropColumn('referrence_voucher_type');
        });
    }
};
