<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sale_return_batches', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('invoice_id')->nullable();
            $table->dateTime('invoice_batch_date')->nullable();
            $table->string('invoice_batch_no')->nullable();
            $table->unsignedBigInteger('account_id')->nullable();
            $table->integer('consultant_id')->nullable();
            $table->integer('last_voucher_count')->nullable();
            $table->unsignedBigInteger('referrence_voucher_id')->nullable();
            $table->string('referrence_voucher_type', 60)->nullable();
           
          
            $table->boolean('incentive')->default(0);
            $table->integer('created_by')->nullable();
            $table->integer('updated_by')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sale_return_batches');
    }
};
