<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('purchase_others_transactions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('purchase_invoice_id')->nullable();
            $table->unsignedBigInteger('purchase_invoice_batch_id')->nullable();
            $table->string("transactions_no", 16)->nullable();
            $table->date("transaction_date")->nullable();
            $table->unsignedBigInteger('module_id')->nullable();
            $table->string("voucher_type", 25)->nullable();
            $table->unsignedBigInteger('account_id')->nullable();
            $table->string("transaction_type", 25)->nullable();
            $table->text("details_narration")->nullable();
            $table->decimal('price', 13, 4)->default(0.0000);
            $table->unsignedBigInteger('currency_id')->nullable();
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('company_id')->nullable();
            $table->unsignedBigInteger('financial_year_id')->nullable();
            $table->boolean('transactions_status')->default(0);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('purchase_others_transactions');
    }
};
