<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('stock_outs', function (Blueprint $table) {
            $table->id();
            $table->text('main_invoice_no')->nullable();
            $table->string('voucher_type_invoice_no')->nullable();
            $table->string('branch_invoice_no')->nullable();
            $table->dateTime('invoice_date')->nullable();
            $table->unsignedBigInteger('voucher_type_id')->nullable();
            $table->string('voucher_type_code')->nullable();
            $table->unsignedBigInteger('patient_id')->nullable();
            $table->unsignedBigInteger('doctor_id')->nullable();
            $table->integer('bill_to_account_id')->nullable();
            $table->integer('tpa_corporate_id')->nullable();
            $table->string('invoice_type')->nullable();
            $table->unsignedBigInteger('collection_agent_id')->nullable();
            $table->unsignedBigInteger('refferal_lab_id')->nullable();
            $table->text('reff_no')->nullable();
            $table->unsignedBigInteger('payment_term_id')->nullable();
            $table->date('order_date')->nullable();
            $table->text('remarks')->nullable();
            $table->unsignedBigInteger('broker_id')->nullable();
            $table->unsignedBigInteger('operator_id')->nullable();
            $table->integer('deleted_by')->nullable();
            $table->integer('updated_by')->nullable();
            $table->unsignedBigInteger('company_id')->nullable();
            $table->text('status')->nullable();
            $table->unsignedBigInteger('financial_year_id')->nullable();
            $table->unsignedInteger('industry_type_id')->nullable();
            $table->unsignedBigInteger('dispatch_from_id')->nullable();
            $table->unsignedBigInteger('ship_to_id')->nullable();
            $table->unsignedBigInteger('tracking_id')->nullable();
            $table->unsignedBigInteger('special_case_id')->nullable();
            $table->unsignedBigInteger('last_voucher_count')->nullable();
            $table->unsignedBigInteger('bussiness_source_id')->nullable();
            $table->unsignedBigInteger('payment_mode_id')->nullable();
            $table->unsignedBigInteger('transaction_mode_id')->nullable();
            $table->integer('last_voucher_type_count')->nullable();
            $table->unsignedBigInteger('third_party_account_id')->nullable();
            $table->integer('last_branch_count')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('stock_outs');
    }
};
