<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('vehicle_registers', function (Blueprint $table) {
            $table->id();
            $table->string('vehicle_no')->nullable(); 
            $table->string('vehicle_model')->nullable();
            $table->integer('manufacture_year')->nullable(); 
            $table->unsignedBigInteger('ownership_type')->nullable(); 
            $table->string('vehicle_type')->nullable(); 
            $table->string('vehicle_capacity')->nullable(); 
            $table->unsignedBigInteger('vendor_ac_id')->nullable(); 
            $table->unsignedBigInteger('driver_ac_id')->nullable(); 
            $table->string('driver_name')->nullable(); 
            $table->string('driver_license_no')->nullable(); 
            $table->string('driver_contact_no')->nullable(); 
            $table->string('driver_whatsapp')->nullable(); 
            $table->text('note')->nullable(); 
            $table->string('status')->nullable();
            $table->string('created_by')->nullable(); 
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('vehicle_registers');
    }
};
