<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
       Schema::table('vehicle_registers', function (Blueprint $table) {
            $table->dropColumn('driver_name');
            $table->dropColumn('driver_license_no');
            $table->dropColumn('driver_contact_no');
            $table->dropColumn('driver_whatsapp');
            $table->boolean('status')->nullable()->default('1')->change();
            $table->unsignedBigInteger('created_by')->nullable()->change(); 
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('vehicle_registers', function (Blueprint $table) {
            $table->string('driver_name')->nullable();
            $table->string('driver_license_no')->nullable();
            $table->string('driver_contact_no')->nullable();
            $table->string('driver_whatsapp')->nullable();
            $table->string('status')->nullable()->change();
            $table->string('created_by')->nullable()->change(); 
        });
    }
};
