<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('vehicle_register_uploads', function (Blueprint $table) {
          
            $table->string('vehicle_no')->nullable()->change(); 
            $table->string('vehicle_model')->nullable()->change();
            $table->string('manufacture_year')->nullable()->change(); 
            $table->string('ownership_type')->nullable()->change(); 
            $table->string('vehicle_type')->nullable()->change(); 
            $table->string('vehicle_capacity')->nullable()->change(); 
            $table->string('vendor_ac_id')->nullable()->change(); 
            $table->string('driver_ac_id')->nullable()->change(); 
            $table->string('note')->nullable()->change(); 
            $table->string('status')->default('1')->nullable()->change();
            $table->string('created_by')->nullable()->change(); 
         
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('vehicle_register_uploads', function (Blueprint $table) {
       
            $table->string('vehicle_no')->nullable(); 
            $table->string('vehicle_model')->nullable();
            $table->integer('manufacture_year')->nullable(); 
            $table->unsignedBigInteger('ownership_type')->nullable(); 
            $table->unsignedBigInteger('vehicle_type')->nullable(); 
            $table->string('vehicle_capacity')->nullable(); 
            $table->unsignedBigInteger('vendor_ac_id')->nullable(); 
            $table->unsignedBigInteger('driver_ac_id')->nullable(); 
            $table->text('note')->nullable(); 
            $table->boolean('status')->default('1')->nullable();
            $table->unsignedBigInteger('created_by')->nullable(); 
            
        });
    }
};
