<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('additional_charges', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('account_id')->index('account_id')->nullable();
            $table->string('voucher_type_code')->nullable();
            $table->string('name');
            $table->string('code');
            $table->decimal('default_rate',10,2)->nullable();
            $table->unsignedBigInteger('tax_slab_id')->index('tax_slab_id')->nullable();
            $table->unsignedBigInteger('primary_unit_id')->index('primary_unit_id')->nullable();  
            $table->boolean('is_mandatory')->default(1);
            $table->boolean('is_expense')->default(1);
            $table->boolean('status')->default(1);
            $table->integer('priority');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('additional_charges');
    }
};
