<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('vehicle_document_validity', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('vehicle_id');
            $table->unsignedBigInteger('document_id');
            $table->date('last_renewal_date')->nullable();
            $table->string('document_no', 255)->nullable();
            $table->date('next_renewal_date')->nullable();
            $table->boolean('is_received')->default(false);
            $table->enum('document_status', ['valid', 'expired', 'pending'])->default('pending');
            $table->timestamps();
            $table->softDeletes();
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->unsignedBigInteger('deleted_by')->nullable();

            // Indexes
            $table->index('vehicle_id');
            $table->index('document_id');
            $table->index('document_no');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('vehicle_document_validity');
    }
};
